<?php
/*
                         ''~``
                        ( o o )
+------------------.oooO--(_)--Oooo.------------------+
|                    Unreal Portal                    |
|                    .oooO                            |
|                    (   )   Oooo.                    |
+---------------------\ (----(   )--------------------+
                       \_)    ) /
                             (_/


           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
           |The Logo Looks Best in Courier New|
           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

                       ---====---
                      Unreal Portal
                       By Cricket
*/

class cp_skin_uportal extends output
{
    public function section_title($title="") {

        $html ="";

        $html .= "<div class='section_title'><h2>{$title}</h2></div>";

        return $html;
    }
    /**
     * Start a table
     *
     * @access  public
     * @param   string      Title
     * @param   string      Description
     * @return  string      HTML
     */
    public function start_table( $title="") {

        $html = "";

        if ($title != "")
        {
            $this->has_title = 1;
            $html .= "<div class='acp-box'>
                        <h3>$title</h3>";
        }



        $html .= "<table class='ipsTable double_pad'>
                      <tbody>";


        if (isset($this->td_header[0]))
        {
            // Auto remove two &nbsp; only headers..

            $this->td_header[1][0] = ( isset($this->td_header[1][0]) AND $this->td_header[1][0] ) ? $this->td_header[1][0] : '';
            $this->td_header[1][1] = ( isset($this->td_header[1][1]) AND $this->td_header[1][1] ) ? $this->td_header[1][1] : '';

            if ( $this->td_header[0][0] == '&nbsp;' && $this->td_header[1][0] == '&nbsp;' && ( ! isset( $this->td_header[2][0] ) ) )
            {
                $this->td_header[0][0] = '{none}';
                $this->td_header[1][0] = '{none}';
            }

            $tds = "";

            foreach ($this->td_header as $td)
            {
                if ($td[1] != "")
                {
                    $width = " width='{$td[1]}' ";
                }
                else
                {
                    $width = "";
                }

                if ($td[0] != '{none}')
                {
                    $tds .= "<th ".$width." style='text-align: center'>{$td[0]}</td>";
                }

                $this->td_colspan++;
            }

            if( $tds )
            {
                $html .= "<tr>{$tds}</tr>";
            }
        }

        return $html;

    }

    /**
     * End a table
     *
     * @access  public
     * @return  string      HTML
     */
    public function end_table() {

        $this->td_header = array();  // Reset TD headers

        if ($this->has_title == 1)
        {
            $this->has_title = 0;

            return "</tbody></table></div><br />";
        }
        else
        {
            return "</tbody></table>";
        }

    }

    /**
     * Add a table row
     *
     * @access  public
     * @param   array       Cell data
     * @param   string      CSS clasname
     * @param   string      align value
     * @return  string      HTML
     */
    public function add_td_row( $array, $css="", $align='middle' ) {

        if (is_array($array))
        {
            $html = "<tr>";

            $count = count($array);

            $this->td_colspan = $count;

            for ($i = 0; $i < $count ; $i++ )
            {
                if ($css != "")
                {
                    $td_col = " class='{$css}'";
                }

                if (is_array($array[$i]))
                {
                    $text    = $array[$i][0];
                    $colspan = $array[$i][1];
                    $td_col  = $array[$i][2] != "" ? $array[$i][2] : $td_col;

                    $html .= "<td{$td_col} colspan='$colspan' valign='$align'>".$text."</td>";
                }
                else
                {
                    if (isset($this->td_header[$i][1]) AND $this->td_header[$i][1] != "")
                    {
                        $width = " width='{$this->td_header[$i][1]}' ";
                    }
                    else
                    {
                        $width = "";
                    }

                    $html .= "<td{$td_col} $width valign='$align'>".$array[$i]."</td>";
                }
            }

            $html .= "</tr>";

            return $html;
        }

    }

    /**
     * Start a form tag
     *
     * @access  public
     * @param   array       Hidden input field names => values
     * @param   string      Form name
     * @param   string      Javascript to add to form tag
     * @param   string      HTML id attribute
     * @return  string      HTML
     */
    public function start_form($hiddens="", $name='theAdminForm', $js="", $id="")
    {
        if ( ! $id )
        {
            $id = $name;
        }

        $form = "<form action='" . $this->settings['base_url'] . "' method='post' name='$name' $js id='$id'>";

        if (is_array($hiddens))
        {
            foreach ($hiddens as $v)
            {
                $form .= "<input type='hidden' name='{$v[0]}' value='{$v[1]}' />";
            }
        }

        //-----------------------------------------
        // Add in auth key
        //-----------------------------------------

        $form .= "<input type='hidden' name='_admin_auth_key' value='".ipsRegistry::getClass('adminFunctions')->_admin_auth_key."' />";

        return $form;
    }

    /**
     * End form (expects to be inside a table)
     *
     * @access  public
     * @param   string      Text
     * @param   string      Javascript
     * @param   string      Extra data to put in table cell
     * @return  string      HTML
     */
    public function end_form($text = "", $js = "", $extra = "")
    {
        $html    = "";
        $colspan = "";

        if ($text != "")
        {
            if ($this->td_colspan > 0)
            {
                $colspan = " colspan='".$this->td_colspan."' ";
            }

            $html .= "<tr><td align='center' style='background-color: whiteSmoke; border-top: 1px solid #D7D7D7' class='tablesubheader'".$colspan."><input type='submit' value='$text'".$js." class='realbutton' accesskey='s'>{$extra}</td></tr>";
        }

        $html .= "</form>";

        return $html;
    }
}

?>